<?php

require_once("../dompdf_config.inc.php");
require_once "functions.inc.php";

if ( isset( $_POST["html"] )) {

  if ( get_magic_quotes_gpc() )
    $_POST["html"] = stripslashes($_POST["html"]);

  $dompdf = new DOMPDF();
  $dompdf->load_html($_POST["html"]);
  $dompdf->set_paper($_POST["paper"], $_POST["orientation"]);
  $dompdf->render();

  $dompdf->stream("dompdf_out.pdf", array("Attachment" => false));

  exit(0);
}

?>

<!DOCTYPE html>
<html lang="en">
<head>
  <title>CONVERTIR HTML EN PDF</title>
  <link rel="stylesheet" href="style.css" type="text/css"/>
  <script type="text/javascript" src="jquery-1.4.2.js"></script>

  <?php if (isset($_SESSION["auth_message"])) { ?>
    <script type="text/javascript">
      alert("<?php echo $_SESSION["auth_message"]; ?>");
    </script>
  <?php } ?>
</head>

<body>
<script type="text/javascript">
function resizePreview(){
  var preview = $("#preview");
  preview.height($(window).height() - preview.offset().top - 2);
}

$(function(){
  var preview = $("#preview");
  resizePreview();

  $(window).scroll(function() {
    var scrollTop = Math.min($(this).scrollTop(), preview.height()+preview.parent().offset().top) - 2;
    preview.css("margin-top", scrollTop + "px");
  });

  $(window).resize(resizePreview);
});
</script>
<div style="height: 10px;">
<iframe id="preview" name="preview" src="about:blank" frameborder="10" marginheight="10" marginwidth="10"></iframe>
</div>
<h2>BOLETINES ACAD&Eacute;MICOS</h2>

<form action="<?php echo $_SERVER["PHP_SELF"];?>" method="post">
    <p>Tama&ntilde;o de Papel y Orientaci&oacute;n:
<select name="paper">
<?php
foreach ( array_keys(CPDF_Adapter::$PAPER_SIZES) as $size )
  echo "<option ". ($size == "letter" ? "selected " : "" ) . "value=\"$size\">$size</option>\n";
?>
</select>
<select name="orientation">
  <option value="portrait">Vertical</option>
  <option value="landscape">Horizontal</option>
</select>
</p>

<textarea name="html" cols="40" rows="20">
&lt;html&gt;
&lt;head&gt;
&lt;style&gt;

/* Type some style rules here */

&lt;/style&gt;
&lt;/head&gt;

&lt;body&gt;

<table border='1'>
<tr>
<td>FLORENCIA - CAQUETA</td>
</tr>
</table>


&lt;/body&gt;
&lt;/html&gt;
</textarea>

<div style="text-align: left; margin-top: 1em;">
  <button type="submit">Mostrar PDF</button>
</div>
  [<a class="button" target="preview" href="/dompdf_modificado/www/demo2.php">PDF</a>]



</form>

</body>

</html>