<?php

require_once "../../../../app/model/db.class.php";
require_once 'bs_info.php';
require_once '../../../../app/model/bs_info_col.php';
require_once('../../../../app/model/FPDF/fpdf.php');

class GenerarPdf extends FPDF
{
    function Header()
    {
        $ob=new InfoCol();
        $arr=$ob->proceso();
        $ob->disconnect();

        $this->Ln(2);
        $this->Image("../../../../fotografias/".$arr[1],16,12,20);
        $this->SetFont("Times","B",10);
        
        $this->SetFont("Times","B",10);
        $this->Cell(30);
        $this->SetTextColor(0,0,0);
        $this->SetFillColor(248,248,255);
        $this->Cell(125,7,($arr[0]),0,0,'C',false);

        if(empty($_REQUEST['sede'])){
            $sd='';
        }else{
            $sd=$_REQUEST['sede'];
        }

        $periodo=$_REQUEST['periodo'];
        $grado=$_REQUEST['grado'];
        $curso=$_REQUEST['curso'];

        $infosede=new Con1();
        $sede=$infosede->sede($sd);
        $infosede->disconnect();
        
        $this->Ln(6);
        $this->SetFont("Times","",10);
        $this->Cell(30);
        $this->SetTextColor(0,0,0);
        $this->SetFillColor(248,248,255);
        $this->Cell(125,7,utf8_decode($sede),0,0,'C',false);

        $this->Ln(6);
        $this->SetFont("Times","B",10);
        $this->Cell(30);
        $this->SetTextColor(0,0,0);
        $this->SetFillColor(248,248,255);
        $this->Cell(125,7, utf8_decode('PUESTOS OCUPADOS EN RENDIMIENTO ACADÉMICO'),0,0,'C',false);


        $this->Ln(6);
        $this->SetFont("Times","B",9);
        $this->Cell(30);
        $this->SetTextColor(0,0,0);
        $this->SetFillColor(248,248,255);
        $this->Cell(125,7, utf8_decode('AÑO LECTIVO : '.date('Y')),0,0,'C',false);

        $this->Ln(5);
        $this->SetFont("Times","B",9);
        $this->Cell(104);
        $this->SetTextColor(0,0,0);
        $this->SetFillColor(248,248,255);
        $this->Cell(125,7,date('d-m-Y'),0,0,'C',false);

        $this->Ln(1);

       
        $obj=new Con1();
        $arr_info=$obj->proceso($periodo,$grado,$curso);
        $obj->disconnect();
        
//        print_r($arr_info);

        if($arr_info!='no')
        {               
        $this->Ln(5);
        $this->SetFont("Times","",9);
        $this->Cell(5);
        $this->SetTextColor(0,0,0);
        $this->SetFillColor(0,0,0);
        $this->Cell(178,0,'',1,0,'C',true);

        $this->Ln(3);
        $this->SetFont("Times","B",9);
        $this->Cell(5);
        $this->SetTextColor(0,0,0);
        $this->SetFillColor(255,255,255);
        $this->Cell(14,5,'Grado:',0,0,'C',true);

        $this->SetFont("Times","B",9);
        $this->Cell(1);
        $this->SetTextColor(0,0,0);
        $this->Cell(10,5,$arr_info[0]['grado'],0,0,'',true);

        
        $this->SetFont("Times","B",9);
        $this->Cell(10);
        $this->SetTextColor(0,0,0);
        $this->SetFillColor(255,255,255);
        $this->Cell(15,5,'Curso:',0,0,'C',true);

        $this->SetFont("Times","B",10);
        $this->Cell(1);
        $this->SetTextColor(0,0,0);
        $this->Cell(35,5,$arr_info[0]['nom_curso'],0,0,'',true);


        $this->SetFont("Times","B",9);
        $this->Cell(10);
        $this->SetTextColor(0,0,0);
        $this->Cell(15,5,'Jornada:',0,0,'C',true);

        $this->SetFont("Times","B",9);
        $this->Cell(1);
        $this->SetTextColor(0,0,0);
        $this->Cell(25,5,$arr_info[0]['nom_jornada'],0,0,'',true);



        $this->SetFont("Times","B",9);
        $this->Cell(10);
        $this->SetTextColor(0,0,0);
        $this->Cell(20,5,'Periodo:',0,0,'C',true);

         $this->SetFont("Times","B",9);
        $this->Cell(1);
        $this->SetTextColor(0,0,0);
        $this->Cell(10,5,$arr_info[0]['periodo'],0,0,'C',true);
        $this->ln(12);


        //---------------------------------------


        $this->SetFont("Times","B",9);
        $this->Cell(4);
        $this->SetFillColor(255,255,255);
        $this->SetTextColor(0,0,0);
        $this->Cell(17,5, utf8_decode('CÓDIGO'),1,0,'C',true);


        $this->SetFont("Times","B",10);
        $this->Cell(1);
        $this->SetTextColor(0,0,0);
        $this->Cell(57,5,'NOMBRES Y APELLIDOS',1,0,'C',true);

        $this->SetFont("Times","B",10);
        $this->Cell(1);
        $this->SetTextColor(0,0,0);
        $this->Cell(6,5,'.b',1,0,'C',true);

        $this->SetFont("Times","B",10);
        $this->Cell(1);
        $this->SetTextColor(0,0,0);
        $this->Cell(6,5,'B',1,0,'C',true);

        $this->SetFont("Times","B",10);
        $this->Cell(1);
        $this->SetTextColor(0,0,0);
        $this->Cell(6,5,'A',1,0,'C',true);

        $this->SetFont("Times","B",10);
        $this->Cell(1);
        $this->SetTextColor(0,0,0);
        $this->Cell(6,5,'S',1,0,'C',true);



        $this->SetFont("Times","b",10);
        $this->Cell(1);
        $this->SetTextColor(0,0,0);
        $this->Cell(18,5,'No. Asign.',1,0,'C',true);

        $this->SetFont("Times","b",10);
        $this->Cell(1);
        $this->SetTextColor(0,0,0);
        $this->Cell(22,5, utf8_decode('Desempeño'),1,0,'C',true);

        $this->SetFont("Times","b",10);
        $this->Cell(1);
        $this->SetTextColor(0,0,0);
        $this->Cell(18,5,'Promedio',1,0,'C',true);

        $this->SetFont("Times","b",10);
        $this->Cell(1);
        $this->SetTextColor(0,0,0);
        $this->Cell(15,5,'Puesto',1,0,'C',true);

        $np=$this->PageNo();
        if($np!=1){
        $this->ln(5);
        }

        }
    }
     
    function datos_Tbla(){

        $periodo=$_REQUEST['periodo'];
        $grado=$_REQUEST['grado'];
        $curso=$_REQUEST['curso'];

        $ob=new Con1();
        $arr=$ob->proceso($periodo,$grado,$curso);
        $ob->disconnect();

        

        $this->SetFillColor(255,255,255);
    
        if($arr!='no')
        { 
        for($i=0;$i<count($arr);$i++)
        {
            $this->ln(5);
            for($a=0;$a<1;$a++)
                {
                    $this->SetFont("Times","",8);
                    $this->Cell(4);
                    $this->SetTextColor(0,0,0);
                    $this->Cell(5,5,$i,1,0,'',true);

                    $this->SetFont("Times","",8);
                    $this->Cell(1);
                    $this->SetTextColor(0,0,0);
                    $this->Cell(11,5,$arr[$i]['alumno'],1,0,'',true);


                    $this->SetFont("Times","",7);
                    $this->Cell(1);
                    $this->SetTextColor(0,0,0);
                    $this->Cell(57,5,$arr[$i]['nombres'],1,0,'',true);



                    $this->SetFont("Times","",10);
                    $this->Cell(1);
                    $this->SetTextColor(0,0,0);
                    $this->Cell(6,5,$arr[$i]['bajo'],1,0,'C',true);

                    $this->SetFont("Times","",10);
                    $this->Cell(1);
                    $this->SetTextColor(0,0,0);
                    $this->Cell(6,5,$arr[$i]['basico'],1,0,'C',true);

                    $this->SetFont("Times","",10);
                    $this->Cell(1);
                    $this->SetTextColor(0,0,0);
                    $this->Cell(6,5,$arr[$i]['alto'],1,0,'C',true);

                    $this->SetFont("Times","",10);
                    $this->Cell(1);
                    $this->SetTextColor(0,0,0);
                    $this->Cell(6,5,$arr[$i]['superior'],1,0,'C',true);



                    $this->SetFont("Times","",10);
                    $this->Cell(1);
                    $this->SetTextColor(0,0,0);
                    $this->Cell(18,5,$arr[$i]['noasign'],1,0,'C',true);

                    $this->SetFont("Times","",10);
                    $this->Cell(1);
                    $this->SetTextColor(0,0,0);
                    $this->Cell(22,5,$arr[$i]['nivel_desempeno'],1,0,'C',true);

                    $this->SetFont("Times","",10);
                    $this->Cell(1);
                    $this->SetTextColor(0,0,0);
                    $this->Cell(18,5,  $this->truncateFloat($arr[$i]['promedio'],3),1,0,'C',true);

                    $this->SetFont("Times","",10);
                    $this->Cell(1);
                    $this->SetTextColor(0,0,0);
                    $this->Cell(15,5,$arr[$i]['puesto'],1,0,'C',true);


                }

             
        }
        
        $this->ln(6);
        $this->SetFont("Times","B",10);
        $this->Cell(84);
        $this->SetTextColor(0,0,0);
        $this->Cell(42,5,'PROMEDIO DEL CURSO  :  ',0,0,'C',true);

        $this->SetFont("Times","B",10);
        $this->Cell(1);
        $this->SetTextColor(0,0,0);
        

       /*------ Hallamos el promedio del Curso -----*/

          $promedio=$ob->consulta("select * from promedio_cursos where periodo='".$periodo."' and grado='".$grado."' and curso='".$curso."'");
          $row1 = $ob->fetch_assoc($promedio);

           if ($row1['promedio']=="")
               $p=0;
           else
               $p=$row1['promedio'];


         $this->Cell(30,5,$this->truncateFloat($p,3)."   -   ".$row1['nivel_desempeno'],0,0,'C',true);

        }
        

      
    }

  function truncateFloat($number, $digitos)
   {
        $raiz = 10;
        $multiplicador = pow ($raiz,$digitos);
        $resultado = ((int)($number * $multiplicador)) / $multiplicador;
        return number_format($resultado, $digitos);

    }
    
}



$pdf=new GenerarPdf();
$pdf->AddPage();

$pdf->datos_Tbla();
$pdf->Output();

?>
