<?php
class mvc_estadistica {
   
//======================== RENDIMIENTO ALUMNOS =================================
    function rendimiento_alumno()
   {

	//carga la plantilla
	$pagina=$this->load_template('','page_rendimiento.php');	       
                 
	$titulo = 'RENDIMIENTO ACADÉMCIO';
	//carga la tabla de la seccion de VIEW
	 $html = $this->load_page('app/views/default/modules/m.table_rendimiento.php');

        $table = $html;
	//realiza el parseado
	$pagina = $this->replace_content('/\#CONTENIDO\#/', $table , $pagina);                      

        $this->view_page($pagina);
   }
   

//============================= ===============================================
   /* METODO QUE MUESTRA LA PAGINA PRINCIPAL CUANDO NO EXISTEN NUEVAS ORDENES
   OUTPUT
   HTML | codigo html de la pagina   
   */
   function principal()
   {
        $pagina=$this->load_template('','page_rendimiento.php');
        $html = $this->load_page('app/views/default/modules/m.principal.php');
        $pagina = $this->replace_content('/\#CONTENIDO\#/' ,$html , $pagina);
        $this->view_page($pagina);
   }
//==============================================================================
	/* METODO QUE CARGA LAS PARTES PRINCIPALES DE LA PAGINA WEB
	INPUT
		$title | titulo en string del header
	OUTPIT
		$pagina | string que contiene toda el cocigo HTML de la plantilla 
	*/
	function load_template($title='',$page=''){
		$pagina = $this->load_page('app/views/default/'.$page);
		$header = $this->load_page('app/views/default/sections/s.header.php');
		$pagina = $this->replace_content('/\#HEADER\#/' ,$header , $pagina);
		$pagina = $this->replace_content('/\#TITLE\#/' ,$title , $pagina);
		$menu_left = $this->load_page('app/views/default/sections/s.menuizquierda.php');
		$pagina = $this->replace_content('/\#MENULEFT\#/' ,$menu_left , $pagina);
		return $pagina;
	}
//==============================================================================
	/* METODO QUE CARGA UNA PAGINA DE LA SECCION VIEW Y LA MANTIENE EN MEMORIA
		INPUT
		$page | direccion de la pagina 
		OUTPUT
		STRING | devuelve un string con el codigo html cargado
	*/	
	private function load_page($page)
	{
		return file_get_contents($page);
	}
//==============================================================================
	/* METODO QUE ESCRIBE EL CODIGO PARA QUE SEA VISTO POR EL USUARIO
		INPUT
		$html | codigo html
		OUTPUT
		HTML | codigo html		
	*/
	private function view_page($html)
	{
		echo $html;
	}
//==============================================================================  
	/* PARSEA LA PAGINA CON LOS NUEVOS DATOS ANTES DE MOSTRARLA AL USUARIO
		INPUT
		$out | es el codigo html con el que sera reemplazada la etiqueta CONTENIDO
		$pagina | es el codigo html de la pagina que contiene la etiqueta CONTENIDO
		OUTPUT
		HTML 	| cuando realiza el reemplazo devuelve el codigo completo de la pagina
	*/
        private function replace_content($in='/\#CONTENIDO\#/', $out,$pagina)
	{
		 return preg_replace($in, $out, $pagina);	 	
	}
	
}
?>